*****************************************************************************
*   Analysis of the cross-sectional data in 2017/18 SIH		          		        
*   Produce graph data on Figure 4 and Figure 5
*****************************************************************************
clear
*import household level data 
use "$path\rawdata\SIH17BH.dta"

*merge with loan level data 
merge 1:1 abshid using "$path\rawdata\SIH17BL.dta", nogen 

*merge with super data calculated from personal level data 
sort abshid
merge 1:1 abshid using "$path\data\SIH17BP_household_super.dta", nogen

*merge with estiamted redraw data 
sort abshid
merge 1:1 abshid using "$path\data\redraw.dta" , nogen
replace hh_redraw=0 if hh_redraw==.


g hwt=sihhhwt

replace dispsch8=0 if dispsch8<0
g dinc_week=dispsch8
g dinc_month=dinc_week*52/12


**********************
*Assets 
***********************
*Liquid assets
g liq_assets_acc = vfinch		// Deposits 
g liq_assets_off = voftch		// Offset	
g liq_assets_eq = vsharch		// Shares
g liq_assets_bond = vdebch		// Bonds	
g liq_assets_tru = vtottch		// Trusts
g liq_assets_oth = vinvotch		// Other financial investment

g liq_assets = liq_assets_acc + liq_assets_off + liq_assets_eq + liq_assets_bond + liq_assets_tru +liq_assets_oth + hh_redraw + hh_liquid_super
g liq_assets_nosuper = liq_assets_acc + liq_assets_off + liq_assets_eq + liq_assets_bond + liq_assets_tru +liq_assets_oth + hh_redraw 
g liq_assets_nosuper_noredraw = liq_assets_acc + liq_assets_off + liq_assets_eq + liq_assets_bond + liq_assets_tru +liq_assets_oth 


*Illiquid assets
g illiq_assets_sup = hh_illiquid_super	// illiquid super 
g illiq_assets_biz = vsipch + vibusch + vubusch		// Partnerships + Inc. Biz + Uninc. Biz
g illiq_assets_hres =  hvaluech + vrprch			// Residential Property
g illiq_assets_hnres = vnrprch						// Non-res Property
g illiq_assets_real = illiq_assets_hres + illiq_assets_hnres
g illiq_assets_oth = vplnch + vcontch + vvehich + votassch	// Loans + Contents + Vehicle + Other
g illiq_assets = illiq_assets_sup + illiq_assets_real + illiq_assets_biz + illiq_assets_oth+hh_illiquid_super

*Total assets 
g asset_to = liq_assets + illiq_assets //this includes liquid super 
g asset_to_nosuper=asset_to-hh_liquid_super //baseline, excludes liquid super, includes redraw
g asset_to_nosuper_noredraw=asset_to-hh_liquid_super-hh_redraw



**********************
*Wealth
***********************
* Liquid wealth
g liq_wlth = liq_assets - liaccch	// Less credit card debt
replace liq_wlth=0 if liq_wlth<0

* Illiquid wealth
g illiq_wlth = illiq_assets - (liasdch + liaopch + liarpch + liavech + liainvch + liaotch + liahecch + liasfsch)

*total wealth 
g wealth_to = liq_wlth + illiq_wlth

g ln_wealth=log(wealth_to)



* housing tenure 
g nomortgage_oo = 0
replace nomortgage_oo = 1 if tenurecf == 1

g indebted_oo = 0
replace indebted_oo = 1 if tenurecf == 2

g renter = 0
replace renter = 1 if tenurecf == 3


* household characteristics
rename agerh age_ref
g age_sqr=age_ref*age_ref 

rename noemphbc number_employed

rename noearnbc number_earner

g no_earner=0
replace no_earner=1 if number_earner ==0

generate single_income=0
replace single_income=1 if number_earner>1

generate dual_income=0
replace dual_income=1 if number_earner==2

*labor force status 
g employed_lfs=1 if lfsrh==1
replace employed_lfs=0 if lfsrh!=1 

g unemployed_lfs=1 if lfsrh==2 
replace unemployed_lfs=0 if lfsrh!=2

g nilf_lfs=1 if lfsrh==3
replace nilf_lfs=0 if lfsrh!=3

* family composition variable dcomph

gen lone_person=0
replace lone_person=1 if dcomp==26 | dcomp==32

gen no_kid=0 //no depedent childre
replace no_kid=1 if dcomph==01 | dcomp==07| dcomp==16 | dcomp==31 //this includes couple wiht indepedent children

gen couple_multi_kid=0 //couple or multiple family with dependent child 
replace couple_multi_kid=1 if dcomph==02 | dcomp==03 | dcomp==04 | dcomp==05 | dcomph==08 
replace couple_multi_kid=1 if dcomp==09 |dcomp==10 | dcomp==11 |dcomph==12 | dcomp==13 
replace couple_multi_kid=1 if dcomp==14 | dcomp==15 |dcomph==27 | dcomp==28  | dcomp==29 | dcomp==30 | dcomph==33 

gen one_parent_kid=0
replace one_parent_kid=1 if  dcomp==17 | dcomp==18 |dcomph==19 | dcomp==20| dcomp==21 | dcomp==22 | dcomp==23 | dcomp==24 


g num_member=femhhbc + malehhbc
g log_num_member=log(num_member)


*fist home buyers 
g fhb=0
replace fhb=1 if fsthhcf==1


*identify investors 
g hh_investor=0
replace hh_investor=1 if liaopch>0
replace hh_investor=1 if liarpch>0


******************************
*Household Liquidity Buffers 
******************************
*includes super
g buffer_super=liq_assets/dinc_month 

*buffer includes estimated redraw, excludes super 
gen buffer=liq_assets_nosuper/dinc_month 
drop if buffer>200

*buffer excludes redraw and super 
gen buffer2=liq_assets_nosuper_noredraw/dinc_month



******************************
*Hand-to-mouth 
******************************
*Set fortnightly household income
g pay = dinc_week*52/26

*Set household credit limit to one month of income (from Kaplan)
g credit_limit = dinc_week*52/12

gen liqnw=liq_wlth

g htm=0
replace htm=1 if (pay/2>=liqnw & liqnw>=0)
replace htm=1 if (pay/2-credit_limit>=liqnw & liqnw<=0)

*age groups 
gen age_group=0
replace age_group=1 if age_ref <=25
replace age_group=2 if age_ref >25 & age_ref <=30
replace age_group=3 if age_ref >30 & age_ref <=35
replace age_group=4 if age_ref >35 & age_ref <=40
replace age_group=5 if age_ref >40 & age_ref <=45
replace age_group=6 if age_ref >45 & age_ref <=50
replace age_group=7 if age_ref >50 & age_ref <=55
replace age_group=8 if age_ref >55 & age_ref <=60

replace age_group=9 if age_ref >60 & age_ref <=65
replace age_group=10 if age_ref >65 & age_ref <=70
replace age_group=11 if age_ref >70 & age_ref <=75
replace age_group=12 if age_ref >75 & age_ref <=80
replace age_group=13 if age_ref >80 





******************************************************
*RDP figures data 
******************************************************
*Liquid assets composition 
g deposit=liq_assets_acc/dinc_month 
g prepayment=(liq_assets_off+hh_redraw)/dinc_month
g shares=liq_assets_eq/dinc_month
g liq_other=(liq_assets_oth+liq_assets_bond+ liq_assets_tru)/dinc_month
g liq_super=hh_liquid_super/dinc_month
g htm_p=htm*100

*Figure 4: Household Liquid Assets, by age of household head 
tabstat deposit prepayment shares liq_other liq_super htm_p [aw=hwt] , by(age_group)

*Figure 5: Household Liquid Assets, by housing tenure 
*outright owner 
tabstat deposit prepayment shares liq_other liq_super htm_p [aw=hwt] if nomortgage_oo==1
*investors 
tabstat deposit prepayment shares liq_other liq_super htm_p [aw=hwt] if hh_investor==1 & indebted_oo==1 
*purely owner-occupiers 
tabstat deposit prepayment shares liq_other liq_super htm[aw=hwt] if hh_investor==0 & indebted_oo==1
*renter 
tabstat deposit prepayment shares liq_other liq_super htm_p [aw=hwt] if renter==1

